using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{

		#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>11/12/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data access component providing database read/write functionality for 
	///	Maximum Surgical Blood Ordering Schedule (MSBOS) data.
	///</summary>

		#endregion

	public class Msbos
	{

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="916"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1905"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Save dataset containing MSBOS and
		/// MSBOS component class information to database, 
		/// returning success indicator
		/// </summary>
		/// <param name="sprocArrayList">List of stored procedures to use</param>
		/// <param name="dtArrayList">ArrayList of DataTables containing canned comment data</param>
		/// <returns>True on success. Otherwise - false.</returns>
		public static bool Save(System.Collections.ArrayList sprocArrayList, System.Collections.ArrayList dtArrayList)
		{
			int returnValue = (new Common.StoredProcedure()).TransactionalGetValue(sprocArrayList,dtArrayList);

			return (returnValue == 0);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="917"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Data table containing orderable blood component classes for division</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1903"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets component classes defined as orderable for given division
		/// </summary>
		/// <returns>DataTable containing component classes</returns>
		public static DataTable GetOrderableComponentClasses()
		{
			DataSet	ds = Common.StoredProcedure.GetData(STOREDPROC.GetOrderableComponentClasses.StoredProcName);
			
			return ds.Tables[0];
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="918"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Data set containing MSBOS and MSBOS component class tables</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1904"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns MSBOS and MSBOS component class
		/// information for a given division
		/// </summary>
		/// <returns>DataSet containing MSBOS and MSBOS component class info</returns>
		public static DataSet GetMsbosEntries()
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetMsbosComponents.divisioncode, System.Data.SqlDbType.VarChar)
			};

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;

			return Common.StoredProcedure.GetData(STOREDPROC.GetMsbosComponents.StoredProcName, prms);
		}
	}
}

